/*
        Remote Shell Trojan (B) Detector
        Qualys 2002 (c)
	HTTP://www.qualys.com

        Usage: rstb_detector host [-r n] [sport dport]
	Eg. rstb_detector 10.10.10.1 -r 50 | sort | uniq
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/udp.h>
#include <netdb.h>
#include <string.h>
#include <arpa/inet.h>
#include <sys/select.h>
#include <string.h>
#include <fcntl.h>
#include <sys/time.h>
#include <getopt.h>

#define LV_LISTEN_PORT		0x1111
#define LV_TIMEOUT		5
#define LV_PAYLOAD_LEN		8
#define LV_DEFAULT_SPORT	53
#define LV_DEFAULT_DPORT	53
#define LV_DEFAULT_RETRIES	1

static int
net_read(int socket, char *buf, size_t n, struct sockaddr *from,
	size_t *fromlen)
{
	fd_set fds;
	int flags;
	static struct timeval tv = { LV_TIMEOUT, 0 };

	flags = fcntl(socket, F_GETFL, 0);
	if (fcntl(socket, F_SETFL, flags | O_NONBLOCK) == -1) {
		perror("fcntl");
		exit(1);
	}

	FD_ZERO(&fds);
	FD_SET(socket, &fds);

	while (1) {
		switch (select(socket + 1, &fds, NULL, NULL, &tv)) {
			case -1:
				perror("select");
				exit(1);
			case  0:
				return 0;
		}
		if (FD_ISSET(socket, &fds)) break;
	}
	return recvfrom(socket, buf, n, 0, from, fromlen);
}

static int
net_bind(int listener, u_short sport)
{
	struct sockaddr_in from;

	from.sin_family = AF_INET;
	from.sin_addr.s_addr = INADDR_ANY;
	from.sin_port = htons(sport);

	return bind(listener, (struct sockaddr *)&from, sizeof(from));
}

static void
getmyip(struct in_addr src, struct in_addr *myip)
{
	struct sockaddr_in so,so1;
	int s;
	size_t i = sizeof(struct sockaddr_in);

	so.sin_addr.s_addr = src.s_addr;
	so.sin_family = AF_INET;
	so.sin_port = 35564;

	s = socket (AF_INET, SOCK_STREAM, IPPROTO_TCP);
	if (s == -1) {
		perror("socket");
		exit(1);
	}

	if ((fcntl(s, F_SETFL, O_NONBLOCK)) == -1) {
		perror("fcntl");
		exit(1);
        }

	connect(s, (struct sockaddr *)&so, i);

	if (getsockname(s, (struct sockaddr *)&so1, &i) == -1 ) {
		perror("getsockname");
		exit(1);
	}

	myip->s_addr =  so1.sin_addr.s_addr;
	close(s);
}

static u_long
resolve(const char *host)
{
	struct hostent *hp;
	u_long ip;

	ip = inet_addr(host);
	if (ip == -1) {
		hp = gethostbyname(host);
		if (hp == NULL) {
			fprintf(stderr, "No such host: %s\n", host);
			exit(1);
		}
		ip = *(u_long *)&hp->h_addr_list[0];
	}
	return ip;
}

int
main(int argc, char *argv[])
{
	char frame[1024];
	struct ip *ip = (struct ip *)frame;
	struct udphdr *udp = (struct udphdr *)&ip[1];
	int sock, listener;
	struct sockaddr_in to;
	struct in_addr myip, dstip;
	char buf[20];
	size_t ihosts = 0;
	size_t len;
	size_t i, retries = LV_DEFAULT_RETRIES;
	int ch;

	while ((ch = getopt(argc, argv, "r:")) != EOF) {
		switch (ch) {
			case 'r':
				retries = atoi(optarg);
				break;
		}
	}

	argc -= optind;
	argv += optind;

	if (argc != 1 && argc != 3) {
		fprintf(stderr, "Usage: rstb_detector [-r retries] host [sport dport]\n");
		exit(1);
	}

	dstip.s_addr = resolve(argv[0]);
	getmyip(dstip, &myip);

	sock = socket(AF_INET, SOCK_RAW, IPPROTO_RAW);
	if (sock == -1) {
		fprintf(stderr,
			"Couldn't create raw socket (maybe not root?)\n");
		exit(1);
	}

	listener = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
	if (listener == -1) {
		perror("socket");
		exit(1);
	}

	if (net_bind(listener, LV_LISTEN_PORT) == -1) {
		perror("socket");
		exit(1);
	}

	memset(frame, 0, sizeof(frame));

	ip->ip_hl = 5;
	ip->ip_v = 4;
	ip->ip_tos = 0x80;
	ip->ip_len = htons(len = LV_PAYLOAD_LEN + sizeof(*ip) + sizeof(*udp));
	ip->ip_id = htons(1000); 
	ip->ip_off = 0;
	ip->ip_ttl = 255;
	ip->ip_p = IPPROTO_UDP;
	ip->ip_sum = 0; /* not necessary, since remote host is sniffing */
	ip->ip_src.s_addr = myip.s_addr;
	ip->ip_dst.s_addr = dstip.s_addr;
	udp->source = htons((argc == 1 ? LV_DEFAULT_SPORT : atoi(argv[1])));
	udp->dest = htons((argc == 1 ? LV_DEFAULT_DPORT : atoi(argv[2])));
	udp->len = htons(LV_PAYLOAD_LEN);
	memcpy(&frame[0x2a - 14], "DOM", 3);
	frame[0x2d - 14] = 2;

	to.sin_family = AF_INET;
	to.sin_addr.s_addr = ip->ip_dst.s_addr;
	to.sin_port = udp->dest;

	for (i = 0; i < retries; i++) {
		if (sendto(sock, frame, len, 0, (struct sockaddr *)&to,
			sizeof(to)) != len
		) exit(1);
	}

	while (1) {
		struct sockaddr_in from;
		size_t fromlen;
		int ret;

		fromlen = sizeof(from);
		ret = net_read(listener, buf, sizeof(buf),
			(struct sockaddr *)&from, &fromlen);
		if (ret ==  0) break;
		if (ret == -1) {
			perror("read");
			exit(1);
		}
		if (ret == 3 && !memcmp(buf, "DOM", 3)) {
			printf("Remote Shell Trojan (B) DETECTED on IP (%s)\n",
				inet_ntoa(from.sin_addr));
			ihosts++;
		}
	}
	if (ihosts == 0)
		printf("Remote Shell Trojan (B) not detected.\n");
	close(listener);
	close(sock);
	exit(0);
}
