/*
	Remote shell trojan disinfector.
	Qualys 2001 (c)
	http://www.qualys.com
	Usage: rst_cleaner file ...
*/

#include <stdio.h>
#include <stdlib.h>
#include <elf.h>
#include <sys/types.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#ifndef EM_486
# define EM_486		6
#endif

static const char corrupt_msg[] = "ERROR: File Corrupt!?: %s\n";

typedef struct {
	char*		map;
	int		fd;
	struct stat	statbuf;
	Elf32_Ehdr*	ehdr;
	Elf32_Phdr*	phdr;
	Elf32_Shdr*	shdr;
	Elf32_Shdr*	shstrtabshdr;
	char*		shstrtab;
	const char*	filename;

	Elf32_Word	padding;
} binary_t;

static int
binary_open(binary_t *binary, const char *filename)
{
	binary->fd = open(filename, O_RDONLY);
	if (binary->fd == -1)
		return -1;
	if (fstat(binary->fd, &binary->statbuf) == -1)
		goto binary_open__error;
	if (binary->statbuf.st_size < 52)
		goto binary_open__error;
	binary->map = mmap(
		NULL,
		binary->statbuf.st_size,
		PROT_READ | PROT_WRITE,
		MAP_PRIVATE,
		binary->fd,
		0
	);
	if (binary->map == (char *)-1) goto binary_open__error;
	if (strncmp(binary->map, ELFMAG, SELFMAG) != 0)
		goto binary_open__error_munmap;
	binary->ehdr = (Elf32_Ehdr *)binary->map;
	if (
		(
			binary->ehdr->e_machine != EM_386 &&
			binary->ehdr->e_machine != EM_486
		) ||
		binary->ehdr->e_type != ET_EXEC
	)
		goto binary_open__error_munmap;
	if (binary->ehdr->e_phnum != 6)
		goto binary_open__error_munmap;
	if (
		(
			binary->ehdr->e_phoff +
			sizeof(Elf32_Phdr)*binary->ehdr->e_phnum
		) > binary->statbuf.st_size
	)
		goto binary_open__error_corrupt;
	binary->phdr = (Elf32_Phdr *)&binary->map[binary->ehdr->e_phoff];
	if (binary->ehdr->e_shoff == 0 || binary->ehdr->e_shnum == 0)
		goto binary_open__error_corrupt;
	if (
		(
			binary->ehdr->e_shoff +
			sizeof(Elf32_Shdr)*binary->ehdr->e_shnum
		) > binary->statbuf.st_size
	)
		goto binary_open__error_corrupt;
	binary->shdr = (Elf32_Shdr *)&binary->map[binary->ehdr->e_shoff];
	if (binary->ehdr->e_shstrndx >= binary->ehdr->e_shnum)
		goto binary_open__error_corrupt;
	binary->shstrtabshdr = &binary->shdr[binary->ehdr->e_shstrndx];
	if (binary->shstrtabshdr->sh_offset > binary->statbuf.st_size)
		goto binary_open__error_corrupt;
	binary->shstrtab = &binary->map[binary->shstrtabshdr->sh_offset];
	binary->filename = filename;
	return 0;

binary_open__error_corrupt:
	printf(corrupt_msg, filename);
binary_open__error_munmap:
	munmap(binary->map, binary->statbuf.st_size);
binary_open__error:
	close(binary->fd);
	return -1;
}

static void
binary_close(binary_t *binary)
{
	munmap(binary->map, binary->statbuf.st_size);
	close(binary->fd);
}

static Elf32_Shdr*
binary_get_section_by_name(binary_t *binary, const char *section)
{
	Elf32_Shdr *shdr;
	int i;

	const int section_len = strlen(section);

	for (
		shdr = binary->shdr, i = 0;
		i < binary->ehdr->e_shnum;
		shdr++, i++
	) {
		if (
			(shdr->sh_name + section_len - 1) >
			binary->shstrtabshdr->sh_size
		) {
			printf(corrupt_msg, binary->filename);
			return NULL;
		}
		if (
			strncmp(
				section,
				&binary->shstrtab[shdr->sh_name],
				section_len
			) == 0 &&
			binary->shstrtab[shdr->sh_name + section_len] == 0
		) 
			return shdr;
	}
	return NULL;
}

static int
binary_padding_infection_present(binary_t *binary)
{
	Elf32_Shdr *shdr;
	Elf32_Word shdr_etext, phdr_etext;

	shdr = binary_get_section_by_name(binary, ".rodata");
	if (shdr == NULL) {
		printf(corrupt_msg, binary->filename);
		return -1;
	}
	shdr_etext = shdr->sh_addr + shdr->sh_size;
	phdr_etext = binary->phdr[2].p_vaddr + binary->phdr[2].p_filesz;
	if (shdr_etext < phdr_etext) {
		binary->padding = shdr->sh_offset + shdr->sh_size;
		return 1;
	}
	return 0;
}

static int
binary_rst_present(binary_t *binary)
{
	static const char rst_signature[] = "\xe9\x6f\x08\00";

	if (binary->statbuf.st_size < 2877)
		return 0;
	return !memcmp(
		&binary->map[binary->statbuf.st_size - 2877],
		rst_signature,
		sizeof(rst_signature) - 1
	);
}

static int
binary_rst_remove(binary_t *binary)
{
	static const char extention[] = ".clean";
	const unsigned int len =
		strlen(binary->filename) + sizeof(extention) + 1;

	char *clean_filename;
	Elf32_Shdr *shdr;
	int i;
	int fd;

	clean_filename = (char *)malloc(len);
	snprintf(clean_filename, len, "%s%s", binary->filename, extention);
	for (
		shdr = binary->shdr, i = 0;
		i < binary->ehdr->e_shnum;
		shdr++, i++
	) {
		if (shdr->sh_offset > binary->padding)
			shdr->sh_offset -= 4096;
	}
	binary->ehdr->e_entry =
		*(Elf32_Word *)&binary->map[1 + binary->padding];
	memset(&binary->map[8], 0, 8);
	binary->ehdr->e_shoff -= 4096;

	binary->phdr[2].p_filesz -= 4096;
	binary->phdr[2].p_memsz -= 4096;
	binary->phdr[3].p_offset -= 4096;
	binary->phdr[4].p_offset -= 4096;

	fd = open(
		clean_filename,
		O_WRONLY | O_CREAT | O_EXCL,
		binary->statbuf.st_mode
	);
	if (fd == -1) {
		perror("open");
		return -1;
	}
	write(fd, binary->map, binary->padding);
	write(
		fd,
		&binary->map[binary->padding + 4096],
		binary->statbuf.st_size - binary->padding - 2877 - 4096
	);
	close(fd);
	return 0;
}

int
main(int argc, char *argv[])
{
	binary_t binary;
	char **filename = argv;
	unsigned int virus_count, new_virus_count;

	if (argc < 2) {
		fprintf(stderr, "Usage: rst_cleaner file ...\n");
		exit(1);
	}

	virus_count = new_virus_count = 0;
	for (filename = &argv[1]; *filename; filename++) {
		if (binary_open(&binary, *filename) != 0)
			continue;

		if (binary_padding_infection_present(&binary) == 1) {
			printf("Binary %s INFECTED\n", *filename);
			virus_count++;
			if (binary_rst_present(&binary) == 1) {
				printf(
					"Remote Shell Trojan present in %s, Cleaning... ",
					*filename
				);
				fflush(stdout);
				binary_rst_remove(&binary);
				printf("Done\n");
			} else {
				printf("Remote Shell Trojan not present.  New Virus??\n");
				new_virus_count++;
			}
		}
		binary_close(&binary);
	}
	printf("Remote Shell Trojan's on system: %i\n", virus_count);
	if (new_virus_count > 0) {
		printf(
			"New Viruses or strains: %i , Please contact Qualys at research@qualys.com\n",
			new_virus_count
		);
	}
	return 0;
}
